/*
 * @(#)ClassDiagram.java  2.0  2006-01-16
 *
 * Copyright (c) 2003-2006 Lucerne University of Applied Sciences and Arts (HSLU)
 * Zentralstrasse 18, Postfach 2858, CH-6002 Lucerne, Switzerland
 * All rights reserved.
 *
 * The copyright of this software is owned by the Lucerne University of Applied 
 * Sciences and Arts (HSLU). You may not use, copy or modify this software, 
 * except in accordance with the license agreement you entered into with HSLU. 
 * For details see accompanying license terms. 
 */

package ch.hslu.cm.oo;

import ch.hslu.cm.*;
import ch.hslu.cm.oo.diagram.OMAssociationFigure;
import ch.hslu.cm.oo.diagram.OMBidirectionalLinkFigure;
import ch.hslu.cm.oo.diagram.OMDependencyFigure;
import ch.hslu.cm.oo.diagram.OMGeneralizationFigure;
import ch.hslu.cm.oo.diagrambsh.ClassFigureBsh;
import ch.hslu.cm.oo.diagrambsh.ObjectFigureBsh;
import ch.hslu.cm.oo.objectmodel.*;
import ch.hslu.cm.oo.objectmodelbsh.*;
import ch.hslu.cm.simulation.*;
import org.jhotdraw.color.ColorUtil;
import java.awt.*;
import java.awt.geom.*;
import org.jhotdraw.draw.io.DOMStorableInputOutputFormat;
import org.jhotdraw.geom.Geom;
/**
 * ClassDiagram.
 *
 * @author  Werner Randelshofer
 * @version 2.0 2006-01-16 Changed to support double precision coordinates.
 * <br>1.0 2. Dezember 2003  Created.
 */
public class ClassDiagram extends AbstractDiagram {
    public final static Color
    CLASS_CONNECTOR_COLOR = new Color(0x99),
    CLASS_NAME_COMPARTMENT_COLOR = new Color(0xc8cce1),
    CLASS_ATTRIBUTE_COMPARTMENT_COLOR = Color.white,
    CLASS_OPERATION_COMPARTMENT_COLOR = Color.white,
    CLASS_STROKE_COLOR = new Color(0x545fa1),
    CLASS_TEXT_COLOR = Color.black,
    CLASS_SHADOW_COLOR = new Color(0xbbbbbb),
    METHOD_CONNECTOR_COLOR = new Color(0x99),
    METHOD_FILL_COLOR = Color.white,
    METHOD_STROKE_COLOR = new Color(0x545fa1),
    OBJECT_SHADOW_COLOR = new Color(0xcccccc),
    OBJECT_CONNECTOR_COLOR = Color.black,
    OBJECT_FILL_COLOR = Color.white,
    OBJECT_STROKE_COLOR = new Color(127,127,127),
    OBJECT_TEXT_COLOR = Color.black,
    ASSOCIATION_STROKE_COLOR = new Color(0x545fa1),
    ASSOCIATION_FILL_COLOR = Color.white,
    DEPENDENCY_STROKE_COLOR = new Color(0x545fa1),
    DEPENDENCY_FILL_COLOR = Color.white,
    GENERALIZATION_STROKE_COLOR = new Color(0x545fa1),
    GENERALIZATION_FILL_COLOR = Color.white,
    LINK_STROKE_COLOR = new Color(127,127,127),
    LINK_FILL_COLOR = Color.white,
    OBJECT_ACTIVE_STROKE_COLOR = Color.black,
    OBJECT_ACTIVE_FILL_COLOR = new Color(200,236,253),
    MESSAGE_STROKE_COLOR = ColorUtil.shadow(new Color(255, 255, 140), 60),//new Color(0x545fa1),
    MESSAGE_FILL_COLOR = new Color(255, 255, 140), //new Color(252,252,120),
    EXCEPTION_STROKE_COLOR = ColorUtil.shadow(new Color(251,202,202), 38),
    EXCEPTION_FILL_COLOR = new Color(251,202,202),
    RESPONSE_STROKE_COLOR = ColorUtil.shadow(new Color(251,198,102), 38),
    RESPONSE_FILL_COLOR = new Color(251,198,102)
    /*,
    METHOD_FC = Color.black,
    METHOD_BC = new Color(200,236,253),
    LINK_FC = Color.black,
    LINK_ACTIVE_FC = Color.red,
    LINK_CONTROL_FC = Color.red,
    LINK_BC = Color.white,
    GENERALIZATION_FC = new Color(0, 0, 0x99),
    GENERALIZATION_BC = Color.white,
    ASSOCIATION_FC = new Color(0, 0, 0x99),
    ASSOCIATION_BC = Color.white;
     */
    ;
    
    public final static int CLASS_LAYER = 0;
    public final static int OBJECT_LAYER = 1;
    public final static int LINK_LAYER = 2;
    public final static int MESSAGE_LAYER = 3;
    
    /** Creates a new instance. */
    public ClassDiagram() {
        this(new ObjectModel());
    }
    public ClassDiagram(ObjectModel simulation) {
        setSimulation(simulation);
    }
    @Override protected DiagramFigure createDiagramFigure(SimulatedObject simElem) {
        switch (simElem.getSimulatedConcept()) {
            case ObjectModel.OBJECT : {
                ObjectFigureBsh f = new ObjectFigureBsh();
                f.setModel((OMBshObject) simElem);
                return f;
            }
            case ObjectModel.CLASS : {
                ClassFigureBsh f = new ClassFigureBsh();
                f.setModel((OMBshClass) simElem);
                return f;
            }
            case ObjectModel.ASSOCIATION : {
                OMAssociationFigure f = new OMAssociationFigure();
                f.setModel((OMAssociation) simElem);
                return f;
            }
            case ObjectModel.LINK : {
                OMBidirectionalLink lnk = (OMBidirectionalLink) simElem;
                
                DiagramFigure start = findFigure(lnk.getStart());
                DiagramFigure end = findFigure(lnk.getEnd());
                if (start != null && end != null) {
                    OMBidirectionalLinkFigure f = new OMBidirectionalLinkFigure();
                    f.setModel(lnk);
                    //f.addNode(new BezierPath.Node());
                    //f.addNode(new BezierPath.Node());
                    Rectangle2D.Double sb = start.getBounds();
                    Rectangle2D.Double eb = end.getBounds();
                    Point2D.Double sp = Geom.angleToPoint(
                    sb, 
                    Geom.pointToAngle(sb, new Point2D.Double(eb.x + eb.width / 2, eb.y + eb.height / 2))
                    );
                    Point2D.Double ep = Geom.angleToPoint(
                    eb, 
                    Geom.pointToAngle(eb, new Point2D.Double(sb.x + sb.width / 2, sb.y + sb.height / 2))
                    );
                    f.setStartConnector(start.findConnector(sp, f));
                    f.setEndConnector(end.findConnector(ep, f));
                    f.lineout();
                    return f;
                }
                return null;
            }
            case ObjectModel.GENERALIZATION : {
                OMGeneralizationFigure f = new OMGeneralizationFigure();
                f.setModel((OMGeneralization) simElem);
                return f;
            }
            case ObjectModel.DEPENDENCY : {
                OMDependencyFigure f = new OMDependencyFigure();
                f.setModel((OMDependency) simElem);
                return f;
            }
            default :
                return null;
        }
    }
}
